
******** Program to create Tabels 12, 14, 15, and 16
******** Provincial-level sex ratio, birth rate, and life expectancy variables are from China Population Census 2000
******** Other variables are from China Statistical Yearbooks or other published sources (see paper for details)
******** All the variables are labeled in stata

use provincesavings.dta, clear               //open the provincial-level savings dataset

   ********Table 12: Summary Statistics of Key Variables in Provincial Panel Regressions

tabstat srt if year==1980 [aw=pop014],stat(mean median sd) col(stat)
tabstat srt if year==1990 [aw=pop014],stat(mean median sd) col(stat)
tabstat srt if year==2000 [aw=pop014],stat(mean median sd) col(stat)
tabstat srt if year==2007 [aw=pop014],stat(mean median sd) col(stat)


tabstat tsaving loginc ssoe shretirement if year==1980 [aw=pop], stat(mean median sd) col(stat)
tabstat tsaving loginc ssoe shretirement if year==1990 [aw=pop], stat(mean median sd) col(stat)
tabstat tsaving loginc ssoe shretirement if year==2000 [aw=pop], stat(mean median sd) col(stat)
tabstat tsaving loginc ssoe shretirement if year==2007 [aw=pop], stat(mean median sd) col(stat)


 *********** Table 14: Sex Ratios and Savings Rate across Provinces - Panel Regression, 1980-2007
eststo ra1: xi: quietly areg tsaving srt loginc shpop1t shpop2t  i.year, absorb(pcode) robust
eststo ra2: xi: quietly areg tsaving srt loginc shpop1t shpop2t  gini i.year, absorb(pcode) robust
eststo ra3: xi: quietly areg tsaving srt loginc shpop1t shpop2t  loge0 i.year , absorb(pcode) robust
eststo ra4: xi: quietly areg tsaving srt loginc shpop1t shpop2t  br0 i.year , absorb(pcode) robust
eststo ra5: xi: quietly areg tsaving srt loginc shpop1t shpop2t  ssoe shretirement i.year, absorb(pcode) robust
eststo ra6: xi: quietly areg tsaving srt loginc shpop1t shpop2t  ssoe shretirement gt i.year if year>1983, absorb(pcode) robust
eststo ra7: xi: quietly areg tsaving srt1 loginc shpop1t shpop2t  ssoe shretirement i.year , absorb(pcode) robust
eststo ra8: xi: quietly areg tsaving srt2 loginc shpop1t shpop2t  ssoe shretirement  i.year , absorb(pcode) robust
eststo ra9: xi: quietly areg tsaving srt1 srt2 loginc shpop1t shpop2t  ssoe shretirement  i.year , absorb(pcode) robust
estout ra*, cells(b(star fmt(%9.2f)) se(par)) drop(_cons)  starlevels(* .10 ** .05 ) ///
        stats(r2_a aic N, fmt(%9.2f %9.0f %9.0g)) indicate("Year effects = _Iyear*"  ) replace 
	

 **************** Table 15: First Stage Regressions for Savings Rate at the Provincial Level 
eststo iv1: xi: quietly areg srt fine1    loginc shpop1t shpop2t  ssoe shretirement i.year, absorb(pcode) robust
eststo iv2: xi: quietly areg srt  premium1    loginc shpop1t shpop2t  ssoe shretirement i.year, absorb(pcode) robust
eststo iv3: xi: quietly areg srt  shmint1   loginc shpop1t shpop2t  ssoe shretirement i.year, absorb(pcode) robust
eststo iv4: xi: quietly areg srt fine1 premium1    loginc shpop1t shpop2t  ssoe shretirement i.year, absorb(pcode) robust
eststo iv5: xi: quietly areg srt fine1 premium1 shmint1   loginc shpop1t shpop2t  ssoe shretirement i.year, absorb(pcode) robust
estout iv1 iv2 iv3 iv4 iv5, cells(b(star fmt(%9.3f)) se(par)) drop(_cons)  starlevels(* .10 ** .05) ///
        stats(r2_a aic F N, fmt(%9.2f %9.0f %9.2f %9.0g)) indicate("Year effects = _Iyear*"  ) replace 
		

***************** Table 16: 2SLS Regressions for Savings at the Provincial Level
eststo ab1: xi: ivreg2 tsaving loginc   (srt=shmint1   fine1 premium1 ) shpop1t shpop2t ssoe shretirement i.pcode i.year , ffirst r
eststo ab2: xi: ivreg2 tsaving loginc   (srt= fine1 premium1  ) shpop1t shpop2t ssoe shretirement i.pcode i.year , ffirst r
eststo ab3: xi: ivreg2 tsaving loginc   (srt= fine1   ) shpop1t shpop2t ssoe shretirement i.pcode i.year , ffirst r
estout ab1 ab2 ab3, cells(b(star fmt(%9.2f)) se(par)) drop(_cons)  starlevels(* .10 ** .05 ) ///
        stats(r2_a aic whf jp widstat N, fmt(%9.2f %9.0f %9.2f %9.2f %9.2f %9.0g)) indicate("Year effects = _Iyear*" "Province effects= _Ipcode*" )  replace 

            **** output the Durbin-Wu_Hausman (whf) test by dropping the robust option from the above regressions
eststo abv1: xi: ivreg2 tsaving loginc (srt = premium1  fine1 shmint1) shpop1t shpop2t ssoe  shretirement i.pcode i.year , ffirst 
ivendog srt
estadd scalar whf= r(WHFp)
eststo abv2: xi: ivreg2 tsaving loginc (srt = premium1  fine1) shpop1t shpop2t ssoe  shretirement i.pcode i.year , ffirst 
ivendog srt
estadd scalar whf= r(WHFp)
eststo abv3: xi: ivreg2 tsaving loginc (srt= fine1) shpop1t shpop2t  ssoe shretirement i.pcode i.year , ffirst 
ivendog srt
estadd scalar whf= r(WHFp)
estout abv1 abv2 abv3, cells(b(star fmt(%9.2f)) se(par)) drop(_cons)  starlevels(* .10 ** .05 *** .01) ///
        stats(r2_a aic whf jp widstat N, fmt(%9.2f %9.0f %9.2f %9.2f %9.2f %9.0g)) indicate("Year effects = _Iyear*" "Province effects= _Ipcode*" ) replace 


